/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.projects.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.ProjectTemplate;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.ProcessStatus;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.git.ui.CloneJob;
import com.aptana.projects.ProjectsPlugin;
import com.aptana.projects.internal.wizards.Messages;
import com.aptana.projects.listeners.IStudioProjectListener;
import com.aptana.projects.templates.IDefaultProjectTemplate;
import com.aptana.projects.wizards.CommonWizardNewProjectCreationPage;
import com.aptana.projects.wizards.IStepIndicatorWizardPage;
import com.aptana.projects.wizards.IWizardProjectCreationPage;
import com.aptana.projects.wizards.ProjectTemplateSelectionPage;
import com.aptana.projects.wizards.ProjectWizardContributionManager;
import com.aptana.ui.util.UIUtils;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.FeatureEvent;
import com.aptana.usage.IStudioAnalytics;
import com.aptana.usage.UsagePlugin;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNewProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    public static final String TEMPLATE_SELECTION_PAGE_NAME = "templateSelectionPage";
    protected IWizardProjectCreationPage mainPage;
    protected ProjectTemplateSelectionPage templatesPage;
    protected WizardNewProjectReferencePage referencePage;
    protected String projectTemplateId;
    protected IProjectTemplate selectedTemplate;
    protected IConfigurationElement configElement;
    protected IProject newProject;
    private URI location;
    private IPath destPath;
    private IProject[] refProjects;
    protected String[] stepNames;
    protected Object data = new Object();
    private boolean deferProjectCreation;

    public AbstractNewProjectWizard() {
        this.initDialogSettings();
    }

    protected abstract String[] getProjectNatures();

    protected abstract String[] getProjectBuilders();

    protected abstract String getProjectCreationDescription();

    protected abstract TemplateType[] getProjectTemplateTypes();

    protected void initDialogSettings() {
        IDialogSettings workbenchSettings = ProjectsPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        ProjectWizardContributionManager projectWizardContributionManager;
        Object[] extraPages;
        super.addPages();
        TemplateType[] templateTypes = this.getProjectTemplateTypes();
        this.validateProjectTemplate(templateTypes);
        LinkedHashMap<String, IStepIndicatorWizardPage> stepPages = new LinkedHashMap<String, IStepIndicatorWizardPage>();
        List<IProjectTemplate> templates = ProjectsPlugin.getDefault().getTemplatesManager().getTemplates(templateTypes);
        if (AbstractNewProjectWizard.hasNonDefaultTemplates(templates) && this.selectedTemplate == null) {
            this.templatesPage = new ProjectTemplateSelectionPage(TEMPLATE_SELECTION_PAGE_NAME, templates);
            this.addPage((IWizardPage)this.templatesPage);
            stepPages.put(this.templatesPage.getStepName(), this.templatesPage);
        }
        this.mainPage = this.createMainPage();
        this.addPage(this.mainPage);
        if (this.mainPage instanceof IStepIndicatorWizardPage) {
            stepPages.put(((IStepIndicatorWizardPage)((Object)this.mainPage)).getStepName(), (IStepIndicatorWizardPage)((Object)this.mainPage));
        }
        if (!ArrayUtil.isEmpty((Object[])(extraPages = (projectWizardContributionManager = ProjectsPlugin.getDefault().getProjectWizardContributionManager()).createPages(this.data, this.getProjectNatures())))) {
            Object[] objectArray = extraPages;
            int n = extraPages.length;
            int n2 = 0;
            while (n2 < n) {
                Object page = objectArray[n2];
                this.addPage((IWizardPage)page);
                if (page instanceof IStepIndicatorWizardPage) {
                    stepPages.put(((IStepIndicatorWizardPage)page).getStepName(), (IStepIndicatorWizardPage)page);
                }
                ++n2;
            }
        }
        this.stepNames = stepPages.keySet().toArray(new String[stepPages.size()]);
        if (this.stepNames.length > 1) {
            for (Object page : stepPages.values()) {
                page.initStepIndicator(this.stepNames);
            }
        }
        projectWizardContributionManager.finalizeWizardPages(this.getPages(), this.getProjectNatures());
    }

    protected boolean deferCreatingProject() {
        return this.deferProjectCreation;
    }

    protected void setDeferCreatingProject(boolean deferProjectCreation) {
        this.deferProjectCreation = deferProjectCreation;
    }

    protected IWizardProjectCreationPage createMainPage() {
        CommonWizardNewProjectCreationPage mainPage = new CommonWizardNewProjectCreationPage("basicNewProjectPage", this.selectedTemplate);
        mainPage.setTitle(Messages.NewProjectWizard_ProjectPage_Title);
        mainPage.setDescription(Messages.NewProjectWizard_ProjectPage_Description);
        return mainPage;
    }

    protected void doCreateProject(IProgressMonitor monitor) throws InvocationTargetException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
                try {
                    AbstractNewProjectWizard.this.createNewProject((IProgressMonitor)subMonitor.newChild(4));
                }
                catch (InvocationTargetException e) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.projects", 0, e.getMessage(), e.getTargetException()));
                }
                ProjectWizardContributionManager projectWizardContributionManager = ProjectsPlugin.getDefault().getProjectWizardContributionManager();
                final IStatus contributorStatus = projectWizardContributionManager.performProjectFinish(AbstractNewProjectWizard.this.newProject, (IProgressMonitor)subMonitor.newChild(1));
                if (contributorStatus != null && !contributorStatus.isOK()) {
                    UIUtils.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractNewProjectWizard_ProjectListenerErrorTitle, (String)contributorStatus.getMessage());
                        }
                    });
                }
                IStudioProjectListener[] projectListeners = new IStudioProjectListener[]{};
                IProjectDescription description = AbstractNewProjectWizard.this.newProject.getDescription();
                if (description != null) {
                    projectListeners = ProjectsPlugin.getDefault().getProjectListenersManager().getProjectListeners(description.getNatureIds());
                }
                int listenerSize = projectListeners.length;
                SubMonitor hookMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (String)Messages.AbstractNewProjectWizard_ProjectListener_TaskName, (int)Math.max(1, listenerSize));
                IStudioProjectListener[] iStudioProjectListenerArray = projectListeners;
                int n = projectListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus status;
                    IStudioProjectListener projectListener = iStudioProjectListenerArray[n2];
                    if (projectListener != null && (status = projectListener.projectCreated(AbstractNewProjectWizard.this.newProject, (IProgressMonitor)hookMonitor.newChild(1))) != null && status.matches(4)) {
                        UIUtils.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                String message = status.getMessage();
                                if (status instanceof ProcessStatus) {
                                    message = ((ProcessStatus)status).getStdErr();
                                }
                                MessageDialog.openError((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractNewProjectWizard_ProjectListenerErrorTitle, (String)message);
                            }
                        });
                    }
                    ++n2;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e, Messages.AbstractNewProjectWizard_ProjectListener_NoDescriptor_Error);
        }
    }

    public boolean performFinish() {
        this.newProject = this.mainPage.getProjectHandle();
        this.destPath = this.mainPage.getLocationPath();
        this.location = null;
        if (!this.mainPage.useDefaults()) {
            this.location = this.mainPage.getLocationURI();
        } else {
            this.destPath = this.destPath.append(this.newProject.getName());
        }
        if (this.templatesPage != null) {
            this.selectedTemplate = this.templatesPage.getSelectedTemplate();
        }
        if (this.referencePage != null) {
            this.refProjects = this.referencePage.getReferencedProjects();
        }
        if (!this.deferCreatingProject()) {
            IStatus projectStatus = this.createAndRefreshProject(true, true, (IProgressMonitor)new NullProgressMonitor());
            return projectStatus.isOK();
        }
        return true;
    }

    protected IStatus createAndRefreshProject(boolean isBlocking, boolean revealProject, IProgressMonitor monitor) {
        IStatus resultStatus = Status.CANCEL_STATUS;
        try {
            if (isBlocking) {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        AbstractNewProjectWizard.this.doCreateProject(monitor);
                    }
                });
            } else {
                this.doCreateProject(monitor);
            }
            resultStatus = Status.OK_STATUS;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExecutionException && t.getCause() instanceof CoreException) {
                CoreException cause = (CoreException)t.getCause();
                resultStatus = cause.getStatus();
                StatusAdapter status = cause.getStatus().getCode() == 275 ? new StatusAdapter((IStatus)new Status(2, "com.aptana.projects", NLS.bind((String)Messages.NewProjectWizard_Warning_DirectoryExists, (Object)this.mainPage.getProjectHandle().getName()), (Throwable)cause)) : new StatusAdapter((IStatus)new Status(cause.getStatus().getSeverity(), "com.aptana.projects", Messages.NewProjectWizard_CreationProblem, (Throwable)cause));
                status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewProjectWizard_CreationProblem);
                StatusManager.getManager().handle(status, 4);
            }
            resultStatus = new Status(2, "com.aptana.projects", 0, NLS.bind((String)Messages.NewProjectWizard_InternalError, (Object)t.getMessage()), t);
            StatusAdapter status = new StatusAdapter(resultStatus);
            status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.NewProjectWizard_CreationProblem);
            StatusManager.getManager().handle(status, 5);
        }
        if (!resultStatus.isOK()) {
            return resultStatus;
        }
        if (revealProject) {
            this.updatePerspective();
            this.selectAndReveal((IResource)this.newProject);
        }
        this.openIndexFile(revealProject);
        this.sendProjectCreateEvent();
        return resultStatus;
    }

    public IProject getCreatedProject() {
        return this.newProject;
    }

    protected abstract String getProjectCreateEventName();

    protected void sendProjectCreateEvent() {
        Map<String, String> payload = this.generatePayload();
        this.sendEvent((AnalyticsEvent)new FeatureEvent(this.getProjectCreateEventName(), payload));
    }

    private void sendEvent(AnalyticsEvent featureEvent) {
        UsagePlugin plugin = UsagePlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IStudioAnalytics analytics = plugin.getStudioAnalytics();
        if (analytics == null) {
            return;
        }
        analytics.sendEvent(featureEvent);
    }

    protected Map<String, String> generatePayload() {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("name", this.newProject.getName());
        if (this.selectedTemplate != null) {
            String id = this.selectedTemplate.getId();
            if (StringUtil.isEmpty((String)id)) {
                payload.put("template", "custom.template-" + this.selectedTemplate.getDisplayName());
            } else {
                payload.put("template", id);
            }
        }
        return payload;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
        if ("projectTemplateId".equals(propertyName) && data instanceof String) {
            this.projectTemplateId = (String)data;
        }
    }

    protected void validateProjectTemplate(TemplateType[] templateType) {
        this.selectedTemplate = null;
        if (this.projectTemplateId != null) {
            List<IProjectTemplate> templates = ProjectsPlugin.getDefault().getTemplatesManager().getTemplates(templateType);
            for (IProjectTemplate template : templates) {
                if (template.getId() == null || !template.getId().equals(this.projectTemplateId)) continue;
                this.selectedTemplate = template;
                return;
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
    }

    private void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
    }

    protected IProject createNewProject(IProgressMonitor monitor) throws InvocationTargetException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProjectDescription description = ResourceUtil.getProjectDescription((IPath)this.destPath, (String[])this.getProjectNatures(), (String[])this.getProjectBuilders());
        description.setName(this.newProject.getName());
        description.setLocationURI(this.location);
        if (this.refProjects != null && this.refProjects.length > 0) {
            description.setReferencedProjects(this.refProjects);
        }
        sub.worked(10);
        if (!this.applySourcedProjectFilesAfterProjectCreated() && this.isCloneFromGit()) {
            this.cloneFromGit(this.newProject, description, (IProgressMonitor)sub.newChild(90));
        } else {
            this.doBasicCreateProject(this.newProject, description, (IProgressMonitor)sub.newChild(75));
            if (!this.applySourcedProjectFilesAfterProjectCreated() && this.selectedTemplate != null && !this.isCloneFromGit()) {
                this.selectedTemplate.apply(this.newProject, true);
            }
        }
        return this.newProject;
    }

    protected boolean applySourcedProjectFilesAfterProjectCreated() {
        return false;
    }

    protected boolean isCloneFromGit() {
        return this.selectedTemplate != null && !this.selectedTemplate.getLocation().endsWith(".zip");
    }

    protected void cloneFromGit(IProject newProjectHandle, IProjectDescription description, IProgressMonitor monitor) throws InvocationTargetException {
        this.doCloneFromGit(this.selectedTemplate.getLocation(), newProjectHandle, description, monitor);
    }

    protected void cloneAfter(IProgressMonitor monitor) throws Exception {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AbstractNewProjectWizard_CloningFromGitMsg, (int)100);
        File tmpFile = File.createTempFile("delete_me", "tmp");
        File dest = new File(tmpFile.getParent(), "git_clone_tmp");
        GitExecutable.instance().clone(this.selectedTemplate.getLocation(), Path.fromOSString((String)dest.getAbsolutePath()), true, (IProgressMonitor)sub.newChild(85));
        IFileStore tmpClone = EFS.getStore((URI)dest.toURI());
        IFileStore dotGit = tmpClone.getChild(".git");
        dotGit.delete(0, (IProgressMonitor)sub.newChild(2));
        IFileStore dotProject = tmpClone.getChild(".project");
        if (dotProject.fetchInfo().exists()) {
            dotProject.delete(0, (IProgressMonitor)sub.newChild(1));
        }
        IFileStore projectStore = EFS.getStore((URI)this.newProject.getLocationURI());
        tmpClone.copy(projectStore, 2, (IProgressMonitor)sub.newChild(9));
        tmpClone.delete(0, (IProgressMonitor)sub.newChild(3));
        sub.done();
    }

    private void doBasicCreateProject(IProject project, IProjectDescription description, IProgressMonitor monitor) throws InvocationTargetException {
        CreateProjectOperation op = new CreateProjectOperation(description, this.getProjectCreationDescription());
        try {
            op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        }
        catch (ExecutionException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void doCloneFromGit(String sourceURI, IProject projectHandle, IProjectDescription projectDescription, IProgressMonitor monitor) throws InvocationTargetException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CloneJob job = new CloneJob(sourceURI, this.destPath.toOSString(), true, true);
        IStatus status = job.run((IProgressMonitor)sub.newChild(100));
        if (!status.isOK()) {
            if (status instanceof ProcessStatus) {
                ProcessStatus ps = (ProcessStatus)status;
                String stderr = ps.getStdErr();
                throw new InvocationTargetException(new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), stderr)));
            }
            throw new InvocationTargetException(new CoreException(status));
        }
        sub.done();
    }

    protected void openIndexFile(boolean activatateEditor) {
        IWorkbenchPage page;
        IFile indexFile = this.newProject.getFile("index.html");
        if (indexFile.exists() && (page = UIUtils.getActivePage()) != null) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)indexFile, (boolean)activatateEditor);
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)ProjectsPlugin.getDefault(), (String)Messages.NewProjectWizard_ERR_OpeningIndex, (Throwable)e);
            }
        }
    }

    protected IPath getDestinationPath() {
        return this.destPath;
    }

    public static void extractZip(IProjectTemplate template, IProject project, Set<IPath> preExistingResources) {
        template.apply(project, !preExistingResources.isEmpty());
    }

    public static void extractZip(IProjectTemplate template, IProject project, boolean promptForOverwrite) {
        template.apply(project, promptForOverwrite);
    }

    public static void extractZip(File zipPath, IProject project, boolean promptForOverwrite, Set<IPath> preExistingResources, boolean isReplacingParameters) {
        new ProjectTemplate(zipPath.getAbsolutePath(), null, "", isReplacingParameters, "", null, "").apply(project, promptForOverwrite);
    }

    private static boolean hasNonDefaultTemplates(List<IProjectTemplate> templates) {
        for (IProjectTemplate template : templates) {
            if (template instanceof IDefaultProjectTemplate) continue;
            return true;
        }
        return false;
    }
}

